package automobile;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.ArrayList;

/**
 * Itérateur pour le Garage, permet l'utilisation de boucles simples sur le garage
 * Inspiré par http://codereview.stackexchange.com/questions/35626/iterator-implementation
 * Il n'était sans doute pas nécessaire de le faire...
 * @author Adrien Poupa
 */
public class IteratorGarage implements Iterator<Vehicule> {

    private List<Vehicule> vehicules;
    private int index;

    /**
     * Constructeur de l'itérateur, met l'index à 0 et renseigne la liste de véhicules
     * @param vehicules ArrayList (considéré comme List) contenant les véhicules du garage
     */
    public IteratorGarage(List<Vehicule> vehicules) {
        this.vehicules = vehicules;
        index = 0;
    }

    /**
     * Constructeur de l'itérateur, met l'index à 0 et renseigne la liste de véhicules
     * @param vehicules TreeSet convertu en ArrayList pour être compatible avec la classe
     */
    public IteratorGarage(TreeSet<Vehicule> vehicules) {
        // Conversion de notre TreeSet en ArrayList
        this.vehicules = new ArrayList<>(vehicules);
        index = 0;
    }

    /**
     * Retourne le véhicule suivant
     * @return véhicule suivant, ou une exception
     */
    @Override
    public Vehicule next() throws NoSuchElementException {
        if(hasNext()) {
            return vehicules.get(index++);
        } else {
            throw new NoSuchElementException("Il n'y a pas d'argument de taille = " + vehicules.size());
        }
    }

    /**
     * Le véhicule actuel a-t-il un successeur ?
     * @return bool true si oui, false si non
     */
    @Override
    public boolean hasNext() {
        return !(vehicules.size() == index);
    }

    /**
     * Suppression d'un élément de la liste
     */
    @Override
    public void remove() {
        if(index <= 0) {
            throw new IllegalStateException("Vous ne pouvez pas supprimer un argument avant un premier appel à next()");
        }
        vehicules.remove(--index);
    }
}